#include <iostream>
#include <vector>
#include <algorithm>

using namespace std;

struct Node {
    int value;
    int index;

    Node(int v, int i) : value(v), index(i) {}
};

class SegmentTree {
private:
    vector<Node> tree;
    int N;

public:
    SegmentTree(int size) {
        N = size;
        tree.resize(4 * N);
    }

    void build(const vector<int>& arr, int node, int start, int end) {
        if (start == end) {
            tree[node] = Node(arr[start], start + 1);
            return;
        }

        int mid = (start + end) / 2;
        int leftChild = 2 * node;
        int rightChild = 2 * node + 1;

        build(arr, leftChild, start, mid);
        build(arr, rightChild, mid + 1, end);

        if (tree[leftChild].value > tree[rightChild].value) {
            tree[node] = tree[leftChild];
        } else {
            tree[node] = tree[rightChild];
        }
    }

    Node query(int node, int start, int end, int left, int right) {
        if (start > right || end < left) {
            return Node(0, 0);
        }

        if (start >= left && end <= right) {
            return tree[node];
        }

        int mid = (start + end) / 2;
        int leftChild = 2 * node;
        int rightChild = 2 * node + 1;

        Node leftResult = query(leftChild, start, mid, left, right);
        Node rightResult = query(rightChild, mid + 1, end, left, right);

        if (leftResult.value > rightResult.value) {
            return leftResult;
        } else {
            return rightResult;
        }
    }

    void update(int node, int start, int end, int index, int newValue) {
        if (start == end) {
            tree[node] = Node(newValue, index);
            return;
        }

        int mid = (start + end) / 2;
        int leftChild = 2 * node;
        int rightChild = 2 * node + 1;

        if (index <= mid) {
            update(leftChild, start, mid, index, newValue);
        } else {
            update(rightChild, mid + 1, end, index, newValue);
        }

        if (tree[leftChild].value > tree[rightChild].value) {
            tree[node] = tree[leftChild];
        } else {
            tree[node] = tree[rightChild];
        }
    }
};

int main() {
    int N;
    cin >> N;

    vector<int> powers(N);
    for (int i = 0; i < N; ++i) {
        cin >> powers[i];
    }

    SegmentTree segmentTree(N);
    segmentTree.build(powers, 1, 0, N - 1);

    int Q;
    cin >> Q;

    for (int i = 0; i < Q; ++i) {
        int Mi, Ji;
        cin >> Mi >> Ji;

        int index = 0;
        int maxRounds = 0;

        while (index < N && powers[index] < Mi) {
            ++index;
        }

        if (index < N) {
            int remainingSwaps = min(Ji, index);
            maxRounds = index + remainingSwaps / 2;
        }

        cout << maxRounds << endl;
    }

    return 0;
}